#version 330

#if VTF_TRANSFORM
uniform sampler1D transformMap;
#else
uniform mat4 world;
#endif
uniform mat4 viewproj;

in vec4 vertex;
in vec4 uv0; //uv, transform idx, texture idx
in vec4 colour;

out vec3 uv;
out vec4 vcolor;

void main()
{
#if VTF_TRANSFORM
	int fetchBase = int(3*uv0.z + 0.5);
	mat3x4 worldT;
	worldT[0] = texelFetch(transformMap, fetchBase, 0);
	worldT[1] = texelFetch(transformMap, fetchBase + 1, 0);
	worldT[2] = texelFetch(transformMap, fetchBase + 2, 0);
	vec4 worldPos = vec4(vertex * worldT, 1);
#else
	vec4 worldPos = world * vertex;
#endif
	uv = vec3(uv0.xy, uv0.w);
	
	vcolor = colour;
	
	gl_Position = viewproj * worldPos;
}
